// This file was generated by modules-webmake (modules for web) project.
// See: https://github.com/medikoo/modules-webmake

(function (modules) {
	'use strict';

	var resolve, getRequire, wmRequire, notFoundError, findFile
	  , extensions = {".js":[],".json":[],".css":[],".html":[]}
	  , envRequire = typeof require === 'function' ? require : null;

	notFoundError = function (path) {
		var error = new Error("Could not find module '" + path + "'");
		error.code = 'MODULE_NOT_FOUND';
		return error;
	};
	findFile = function (scope, name, extName) {
		var i, ext;
		if (typeof scope[name + extName] === 'function') return name + extName;
		for (i = 0; (ext = extensions[extName][i]); ++i) {
			if (typeof scope[name + ext] === 'function') return name + ext;
		}
		return null;
	};
	resolve = function (scope, tree, path, fullPath, state, id) {
		var name, dir, exports, module, fn, found, ext;
		path = path.split('/');
		name = path.pop();
		if ((name === '.') || (name === '..')) {
			path.push(name);
			name = '';
		}
		while ((dir = path.shift()) != null) {
			if (!dir || (dir === '.')) continue;
			if (dir === '..') {
				scope = tree.pop();
				id = id.slice(0, id.lastIndexOf('/'));
			} else {
				tree.push(scope);
				scope = scope[dir];
				id += '/' + dir;
			}
			if (!scope) throw notFoundError(fullPath);
		}
		if (name && (typeof scope[name] !== 'function')) {
			found = findFile(scope, name, '.js');
			if (!found) found = findFile(scope, name, '.json');
			if (!found) found = findFile(scope, name, '.css');
			if (!found) found = findFile(scope, name, '.html');
			if (found) {
				name = found;
			} else if ((state !== 2) && (typeof scope[name] === 'object')) {
				tree.push(scope);
				scope = scope[name];
				id += '/' + name;
				name = '';
			}
		}
		if (!name) {
			if ((state !== 1) && scope[':mainpath:']) {
				return resolve(scope, tree, scope[':mainpath:'], fullPath, 1, id);
			}
			return resolve(scope, tree, 'index', fullPath, 2, id);
		}
		fn = scope[name];
		if (!fn) throw notFoundError(fullPath);
		if (fn.hasOwnProperty('module')) return fn.module.exports;
		exports = {};
		fn.module = module = { exports: exports, id: id + '/' + name };
		fn.call(exports, exports, module, getRequire(scope, tree, id));
		return module.exports;
	};
	wmRequire = function (scope, tree, fullPath, id) {
		var name, path = fullPath, t = fullPath.charAt(0), state = 0;
		if (t === '/') {
			path = path.slice(1);
			scope = modules['/'];
			if (!scope) {
				if (envRequire) return envRequire(fullPath);
				throw notFoundError(fullPath);
			}
			id = '/';
			tree = [];
		} else if (t !== '.') {
			name = path.split('/', 1)[0];
			scope = modules[name];
			if (!scope) {
				if (envRequire) return envRequire(fullPath);
				throw notFoundError(fullPath);
			}
			id = name;
			tree = [];
			path = path.slice(name.length + 1);
			if (!path) {
				path = scope[':mainpath:'];
				if (path) {
					state = 1;
				} else {
					path = 'index';
					state = 2;
				}
			}
		}
		return resolve(scope, tree, path, fullPath, state, id);
	};
	getRequire = function (scope, tree, id) {
		return function (path) {
			return wmRequire(scope, [].concat(tree), path, id);
		};
	};
	return getRequire(modules, [], '');
})({
	"ab-page-testing": {
		"assets": {
			"js": {
				"collections": {
					"base.js": function (exports, module, require) {
						eval("var traffic_model = require( '../models/traffic' );\n\nmodule.exports = Backbone.Collection.extend( {\n\n\n\t/**\n\t * Based on the excluded_model traffic\n\t * Distributes the remaining traffic equally to the other models in collection\n\t *\n\t * @param excluded_model\n\t */\n\tdistribute_traffic: function ( excluded_model ) {\n\n\t\tif ( this.length <= 1 ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar _new_traffic = parseInt( (100 - excluded_model.get( 'traffic' )) / (this.length - 1) );\n\n\t\tthis.each( function ( model ) {\n\t\t\tif ( model.get( model.idAttribute ) !== excluded_model.get( excluded_model.idAttribute ) ) {\n\t\t\t\tmodel.set( 'traffic', _new_traffic );\n\t\t\t}\n\t\t}, this );\n\n\t\tvar _rest = (100 - excluded_model.get( 'traffic' )) % (this.length - 1);\n\n\t\t/**\n\t\t * add rest to 1st or last element from collection\n\t\t */\n\t\tif ( _rest ) {\n\t\t\tvar _last_model = this.last();\n\t\t\tif ( _last_model.get( _last_model.idAttribute ) === excluded_model.get( excluded_model.idAttribute ) ) {\n\t\t\t\tthis.first().set( 'traffic', _new_traffic + _rest );\n\t\t\t} else {\n\t\t\t\t_last_model.set( 'traffic', _new_traffic + _rest );\n\t\t\t}\n\t\t}\n\t},\n\n\t/**\n\t * split the removed traffic equally to remained items\n\t *\n\t * @param excluded_model\n\t * @param traffic\n\t */\n\tsplit_traffic: function ( excluded_model, traffic ) {\n\n\t\tvar split_traffic = parseInt( traffic / (this.length - 1) );\n\n\t\tthis.each( function ( model ) {\n\t\t\tif ( model.get( model.idAttribute ) === excluded_model.get( excluded_model.idAttribute ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tmodel.set( 'traffic', model.get( 'traffic' ) + split_traffic );\n\n\t\t}, this );\n\n\t\tvar _rest = parseInt( traffic % (this.length - 1) );\n\n\t\t/**\n\t\t * add rest to 1st or last element from collection\n\t\t */\n\t\tif ( _rest ) {\n\t\t\tvar _last_model = this.last();\n\t\t\tif ( _last_model.get( _last_model.idAttribute ) === excluded_model.get( excluded_model.idAttribute ) ) {\n\t\t\t\tvar _first = this.first();\n\t\t\t\t_first.set( 'traffic', _first.get( 'traffic' ) + _rest );\n\t\t\t} else {\n\t\t\t\t_last_model.set( 'traffic', _last_model.get( 'traffic' ) + _rest );\n\t\t\t}\n\t\t}\n\t},\n\n\t/**\n\t * Create a new Traffic Model with traffic prop from the collection\n\t * and send it to server to be saved\n\t */\n\tsave_distributed_traffic: function () {\n\n\t\tvar traffic = new traffic_model();\n\n\t\tthis.each( function ( model ) {\n\t\t\ttraffic.set( model.get( model.idAttribute ), model.get( 'traffic' ) );\n\t\t}, this );\n\n\t\ttraffic.save();\n\t},\n\tequalize_traffic: function () {\n\n\t\tvar new_traffic = parseInt( 100 / this.length ),\n\t\t\tmod = 100 % this.length;\n\n\t\tthis.each( function ( model ) {\n\t\t\tmodel.set( 'traffic', new_traffic );\n\t\t} );\n\n\t\tthis.findWhere( {is_control: true} ).set( 'traffic', new_traffic + mod );\n\t},\n\tallocate_traffic: function ( excluded_model, diff ) {\n\n\t\tthis.each( function ( model ) {\n\n\t\t\tif ( model.get( model.idAttribute ) === excluded_model.get( excluded_model.idAttribute ) ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar traffic = parseInt( model.get( 'traffic' ) );\n\n\t\t\tvar _new_traffic = traffic + diff;\n\n\t\t\tif ( _new_traffic < 0 ) {\n\t\t\t\tdiff = _new_traffic;\n\t\t\t\t_new_traffic = 0;\n\t\t\t} else if ( _new_traffic > 100 ) {\n\t\t\t\tdiff = _new_traffic - 100;\n\t\t\t\t_new_traffic = 100;\n\t\t\t} else {\n\t\t\t\tdiff = 0;\n\t\t\t}\n\n\t\t\tmodel.set( 'traffic', _new_traffic );\n\n\t\t}, this );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/collections/base.js");
					},
					"test-items.js": function (exports, module, require) {
						eval("var base = require( './base' ),\n\ttraffic_model = require( '../models/traffic' );\n\nmodule.exports = base.extend( {\n\n\tmodel: require( '../models/test-item' ),\n\n\tsave_distributed_traffic: function () {\n\n\t\tvar traffic = new traffic_model();\n\n\t\tthis.each( function ( model ) {\n\t\t\ttraffic.set( model.get( 'variation_id' ), model.get( 'traffic' ) );\n\t\t}, this );\n\n\t\ttraffic.save();\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/collections/test-items.js");
					},
					"variations.js": function (exports, module, require) {
						eval("var base = require( './base' );\n\nmodule.exports = base.extend( {\n\n\tmodel: require( '../models/variation' )\n\n} );\n//# sourceURL=ab-page-testing/assets/js/collections/variations.js");
					}
				},
				"controls": {
					"edit_title.js": function (exports, module, require) {
						eval("var base_view = require( './../views/base' );\n\nmodule.exports = base_view.extend( {\n\tclassName: 'tvd-input-field',\n\ttemplate: TVE_Dash.tpl( 'util/edit-title' ),\n\tevents: {\n\t\t'keyup input': 'keyup',\n\t\t'change input': function () {\n\t\t\tvar trim_value = this.input.val().trim();\n\t\t\tif ( ! trim_value ) {\n\t\t\t\tthis.input.addClass( 'tvd-invalid' );\n\t\t\t\treturn false;\n\t\t\t}\n\t\t\tthis.model.set( 'post_title', trim_value );\n\t\t\treturn false;\n\t\t},\n\t\t'blur input': function () {\n\t\t\tthis.model.trigger( 'thrive-ab-title-no-change' );\n\t\t}\n\t},\n\tinitialize: function ( args ) {\n\n\t\tvar is_valid_args = true;\n\n\t\tif ( ! args ) {\n\t\t\tis_valid_args = false;\n\t\t}\n\n\t\tif ( typeof args !== 'object' ) {\n\t\t\tis_valid_args = false;\n\t\t}\n\n\t\tif ( typeof args === 'object' && typeof args.el === 'undefined' ) {\n\t\t\tis_valid_args = false;\n\t\t}\n\n\t\tif ( ! is_valid_args ) {\n\t\t\tconsole.log( 'Error: invalid arguments for edit title control' );\n\t\t\treturn;\n\t\t}\n\n\t\tthis.render();\n\t},\n\n\tkeyup: function ( event ) {\n\t\tif ( event.which === 27 ) {\n\t\t\tthis.model.trigger( 'thrive-ab-title-no-change' );\n\t\t}\n\t},\n\trender: function () {\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\t\tthis.input = this.$( 'input' );\n\n\t\treturn this;\n\t},\n\tfocus: function () {\n\t\tthis.input.focus().select();\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/controls/edit_title.js");
					},
					"page_search.js": function (exports, module, require) {
						eval("/**\n * Autocomplete input\n */\nvar base_view = Backbone.View,\n\tbase_model = require( './../models/base' );\n\nvar page_model = base_model.extend( {\n\n\tdefaults: function () {\n\t\treturn {\n\t\t\tpost_id: '',\n\t\t\tpost_title: ''\n\t\t};\n\t},\n\n\tvalidate: function ( attrs ) {\n\n\t\tvar _errors = [];\n\n\t\tif ( ! attrs.post_title || ! attrs.post_id ) {\n\t\t\t_errors.push( this.validation_error( 'post_title', 'Page not selected' ) );\n\t\t}\n\n\t\treturn _errors.length ? _errors : undefined;\n\t}\n} );\n\nvar view = base_view.extend( {\n\n\tclassName: 'tvd-input-field thrive-ab-page-search',\n\n\ttemplate: TVE_Dash.tpl( 'util/page-search' ),\n\n\tinitialize: function ( attrs ) {\n\n\t\tif ( ! attrs || ! attrs.model ) {\n\t\t\tthis.model = new page_model();\n\t\t}\n\t\tthis.goal_pages = attrs.goal_pages;\n\n\t\tthis.on( 'select', this.select );\n\t\tthis.on( 'save-page', this.save_page );\n\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\n\t\tTVE_Dash.data_binder( this );\n\n\t\tthis.$autocomplete = this.$( '.page-search' );\n\t\tthis.$autocomplete.on( 'input', _.bind( function () {\n\t\t\tthis.model.set( {\n\t\t\t\tpost_id: null\n\t\t\t} );\n\t\t\tthis.$( '.thrive-ab-edit-page' ).attr( 'href', 'javascript:void(0)' ).addClass( 'tvd-btn-flat-secondary' );\n\t\t\tthis.$( '.thrive-ab-preview-page' ).attr( 'href', 'javascript:void(0)' ).addClass( 'tvd-btn-flat-secondary' );\n\t\t}, this ) );\n\n\t\tthis.bind();\n\n\t\treturn this;\n\t},\n\tselect: function ( item ) {\n\t\tthis.$( '.thrive-ab-edit-page' ).attr( 'href', item.edit_url ).removeClass( 'tvd-btn-flat-secondary' ).show();\n\t\tthis.$( '.thrive-ab-preview-page' ).attr( 'href', item.url ).removeClass( 'tvd-btn-flat-secondary' ).show();\n\t},\n\tsave_page: function ( item ) {\n\n\t\tvar self = this,\n\t\t\t_options = {\n\t\t\t\ttitle: item.title\n\t\t\t};\n\n\t\tTVE_Dash.showLoader();\n\n\t\tThriveAB.ajax.do( 'add_new_page', 'post', _options ).done( function ( response ) {\n\t\t\tself.model.set( {\n\t\t\t\tpost_id: response.post.ID,\n\t\t\t\tpost_title: response.post.post_title\n\t\t\t} );\n\t\t\tself.select( {\n\t\t\t\tedit_url: response.post.edit_url,\n\t\t\t\turl: response.post.guid\n\t\t\t} );\n\t\t\tTVE_Dash.hideLoader();\n\t\t} );\n\t},\n\tbind: function () {\n\t\tvar self = this,\n\t\t\tlast,\n\t\t\tcache;\n\n\t\tthis.$autocomplete.autocomplete( {\n\t\t\tappendTo: this.$el,\n\t\t\tminLength: 2,\n\t\t\tdelay: 300,\n\t\t\tsource: function ( request, response ) {\n\t\t\t\tvar exclude_ids;\n\t\t\t\tif ( self.goal_pages ) {\n\t\t\t\t\texclude_ids = Object.keys( self.goal_pages );\n\t\t\t\t\texclude_ids.push( ThriveAB.page.ID );\n\t\t\t\t} else {\n\t\t\t\t\texclude_ids = [ThriveAB.page.ID];\n\t\t\t\t}\n\t\t\t\tvar _options = {\n\t\t\t\t\tq: request.term,\n\t\t\t\t\texclude_id: exclude_ids\n\t\t\t\t};\n\n\t\t\t\tThriveAB.ajax.do( 'post_search', 'post', _options )\n\t\t\t\t        .done( function ( data ) {\n\t\t\t\t\t        if ( true || data.length === 0 ) {\n\t\t\t\t\t\t        data.push( {\n\t\t\t\t\t\t\t        title: request.term,\n\t\t\t\t\t\t\t        label: request.term,\n\t\t\t\t\t\t\t        type: 'Create New Page',\n\t\t\t\t\t\t\t        value: request.term\n\t\t\t\t\t\t        } );\n\t\t\t\t\t        }\n\n\t\t\t\t\t        cache = data;\n\t\t\t\t\t        response( data );\n\t\t\t\t        } );\n\n\t\t\t\tlast = request.term;\n\t\t\t},\n\t\t\tselect: function ( event, ui ) {\n\t\t\t\tself.$autocomplete.val( ui.item.title );\n\n\t\t\t\tself.model.set( {\n\t\t\t\t\tpost_id: ui.item.id,\n\t\t\t\t\tpost_title: ui.item.title\n\t\t\t\t} );\n\n\t\t\t\tif ( ui.item.id ) {\n\t\t\t\t\tself.trigger( 'select', ui.item );\n\t\t\t\t}\n\n\t\t\t\treturn false;\n\t\t\t}\n\t\t} );\n\t\tthis.$autocomplete.data( 'ui-autocomplete' )._renderItem = function ( ul, item ) {\n\t\t\tvar $li = jQuery( '<li/>' );\n\n\t\t\tif ( typeof item.id === 'undefined' ) {\n\t\t\t\t$li.addClass( 'ui-not-found' );\n\t\t\t\t$li.click( function () {\n\t\t\t\t\tself.trigger( 'save-page', item );\n\t\t\t\t} );\n\t\t\t}\n\n\t\t\tvar _html;\n\n\t\t\tif ( item.type === 'Create New Page' ) {\n\t\t\t\t_html = '<span class=\"post-name\" style=\"width: 60%\">' + item.label + '</span><span class=\"post-type\" style=\"width: 40%\">' + item.type + '</span>';\n\t\t\t} else {\n\t\t\t\t_html = '<span class=\"post-name\">' + item.label + '</span><span class=\"post-type\">' + item.type + '</span>';\n\t\t\t}\n\n\t\t\t$li.append( _html ).appendTo( ul );\n\n\t\t\treturn $li;\n\t\t};\n\t}\n} );\n\nmodule.exports = {\n\tmodel: page_model,\n\tview: view\n};\n//# sourceURL=ab-page-testing/assets/js/controls/page_search.js");
					},
					"range.js": function (exports, module, require) {
						eval("var base = require( '../views/base' );\n\nmodule.exports = base.extend( {\n\n\tinitialize: function () {\n\t\tbase.prototype.initialize.apply( this, arguments );\n\n\t\tthis.$( 'input' ).attr( 'data-value', this.model.get( 'traffic' ) );\n\n\t\tthis.listenTo( this.model, 'change:traffic', function ( model, _value ) {\n\t\t\tthis.$( 'input' ).val( _value );\n\t\t\tthis.$( 'input' ).attr( 'data-value', _value );\n\t\t} );\n\n\t\tif ( this.model.collection.length === 1 ) {\n\t\t\tthis.disable();\n\t\t}\n\t},\n\n\ton_change: function ( event ) {\n\n\t\tthis.model.collection.save_distributed_traffic();\n\n\t\treturn false;\n\t},\n\n\ton_input: function ( event ) {\n\n\t\tvar _value = event.target.value;\n\n\t\tif ( _value.length <= 0 ) {\n\t\t\tevent.target.value = 0;\n\t\t}\n\n\t\tif ( isNaN( parseInt( _value ) ) || parseInt( _value ) > 100 ) {\n\t\t\t_value = _value.substring( 0, _value.length - 1 );\n\t\t}\n\n\t\tif ( isNaN( parseInt( _value ) ) ) {\n\t\t\t_value = 0;\n\t\t}\n\n\t\tevent.target.value = parseInt( _value );\n\n\t\tvar _diff = parseInt( event.target.dataset.value ) - _value;\n\t\t_diff = parseInt(_diff);\n\n\t\tthis.set_traffic( parseInt( event.target.value ), _diff );\n\n\t\treturn false;\n\t},\n\n\tset_traffic: function ( value, diff ) {\n\n\t\tvar _value = parseInt( value );\n\n\t\tif ( isNaN( _value ) ) {\n\t\t\t_value = 0;\n\t\t}\n\n\t\tif ( _value < 0 ) {\n\t\t\t_value = 0;\n\t\t}\n\n\t\tif ( _value > 100 ) {\n\t\t\t_value = 100;\n\t\t}\n\n\t\tthis.model.set( 'traffic', _value );\n\n\t\t//this.model.collection.distribute_traffic( this.model );\n\t\tvar traffic_alocated = this.model.collection.allocate_traffic( this.model, diff );\n\t},\n\n\tenable: function () {\n\t\tthis.$( 'input' ).removeAttr( 'disabled' );\n\t},\n\n\tdisable: function () {\n\t\tthis.$( 'input' ).attr( 'disabled', 'disabled' );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/controls/range.js");
					}
				},
				"main.js": function (exports, module, require) {
					eval("(function ( $ ) {\n\n\t//DOM ready\n\t$( function () {\n\n\t\tvar ThriveAB = window.ThriveAB || {},\n\t\t\tutil = require( './util' ),\n\t\t\trouter = require( './router' );\n\n\t\t_.extendOwn( ThriveAB.ajax, util.ajax );\n\n\t\tBackbone.emulateHTTP = true;\n\n\t\tThriveAB.router = new router();\n\t\tBackbone.history.stop();\n\t\tBackbone.history.start();\n\n\t\tif ( ! Backbone.history.fragment ) {\n\n\t\t\tif ( ThriveAB.current_test ) {\n\t\t\t\treturn ThriveAB.router.navigate( '#test', {trigger: true} );\n\t\t\t}\n\n\t\t\tif ( ThriveAB.running_test ) {\n\t\t\t\tThriveAB.router.navigate( '#test/' + ThriveAB.running_test.id, {trigger: true} );\n\t\t\t} else {\n\t\t\t\tThriveAB.router.navigate( '#dashboard', {trigger: true} );\n\t\t\t}\n\t\t}\n\t} );\n\n})( jQuery );\n//# sourceURL=ab-page-testing/assets/js/main.js");
				},
				"modals": {
					"archive.js": function (exports, module, require) {
						eval("/**\n * General Archive Modal\n */\nmodule.exports = TVE_Dash.views.Modal.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'modals/html-archive' ),\n\n\tevents: {\n\t\t'click .tvd-modal-submit': 'submit'\n\t},\n\n\tinitialize: function ( args ) {\n\n\t\tTVE_Dash.views.Modal.prototype.initialize.apply( this, arguments );\n\t\tthis.$el.addClass( 'tvd-red' );\n\t},\n\n\trender: function () {\n\n\t\tTVE_Dash.views.Modal.prototype.render.apply( this, arguments );\n\t\tthis.$( '.tvd-modal-close' ).addClass( 'tvd-white-text' );\n\n\t\treturn this;\n\t},\n\n\tsubmit: function () {\n\n\t\tif ( typeof this.data['submit'] !== 'function' ) {\n\t\t\tthrow new Error( 'Submit data not implemented' );\n\t\t}\n\t\tthis.data.submit.apply( this, arguments );\n\n\t\tthis.close();\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/archive.js");
					},
					"automatic-winner-settings.js": function (exports, module, require) {
						eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 12/14/2017\n * Time: 1:04 PM\n */\nmodule.exports = TVE_Dash.views.Modal.extend( {\n\ttemplate: TVE_Dash.tpl( 'modals/html-change-automatic-winner' ),\n\tevents: {\n\t\t'click .tvd-modal-submit': 'submit'\n\t},\n\tafterInitialize: function ( args ) {\n\t\tTVE_Dash.views.Modal.prototype.afterInitialize.apply( this, arguments );\n\n\t\tthis.listenTo( this.model, 'change:auto_win_enabled', this.toggle_settings_input );\n\t},\n\n\tafterRender: function () {\n\t\tTVE_Dash.views.Modal.prototype.afterRender.apply( this, arguments );\n\t\tTVE_Dash.data_binder( this );\n\t\tthis.toggle_settings_input();\n\t},\n\ttoggle_settings_input: function () {\n\n\t\tvar _inputs = this.$( '#auto-win-settings input' ),\n\t\t\t_auto_win = this.model.get( 'auto_win_enabled' );\n\n\t\tthis.$( '#auto-win-enabled' ).prop( 'checked', _auto_win == 1 );\n\n\t\tif ( _inputs.length ) {\n\t\t\tif ( _auto_win == 1 ) {\n\t\t\t\t_inputs.removeAttr( 'disabled' );\n\t\t\t} else {\n\t\t\t\tvar defaults = this.model.defaults();\n\t\t\t\tdelete defaults.id;\n\t\t\t\tthis.model.set( defaults );\n\t\t\t\t_inputs.attr( 'disabled', 'disabled' );\n\t\t\t}\n\t\t}\n\t},\n\tsubmit: function () {\n\n\t\tif ( ! this.model.isValid( {step: 'winner_settings'} ) ) {\n\t\t\treturn;\n\t\t}\n\n\t\tvar save_options = {\n\t\t\tsave_test_settings: true\n\t\t};\n\n\t\tthis.model.save( save_options, {\n\t\t\tsuccess: _.bind( function () {\n\t\t\t\tthis.close();\n\t\t\t}, this ),\n\t\t\terror: _.bind( function () {\n\t\t\t\tthis.close();\n\t\t\t}, this )\n\t\t} );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/automatic-winner-settings.js");
					},
					"delete.js": function (exports, module, require) {
						eval("/**\n * General Delete Modal\n */\nmodule.exports = TVE_Dash.views.Modal.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'modals/html-delete' ),\n\n\tevents: {\n\t\t'click .tvd-modal-submit': 'submit'\n\t},\n\n\tinitialize: function ( args ) {\n\n\t\tTVE_Dash.views.Modal.prototype.initialize.apply( this, arguments );\n\t\tthis.$el.addClass( 'tvd-red' );\n\t},\n\n\trender: function () {\n\n\t\tTVE_Dash.views.Modal.prototype.render.apply( this, arguments );\n\t\tthis.$( '.tvd-modal-close' ).addClass( 'tvd-white-text' );\n\n\t\treturn this;\n\t},\n\n\tsubmit: function () {\n\n\t\tif ( typeof this.data['submit'] !== 'function' ) {\n\t\t\tthrow new Error( 'Submit data not implemented' );\n\t\t}\n\t\tthis.data.submit.apply( this, arguments );\n\n\t\tthis.close();\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/delete.js");
					},
					"goal.js": function (exports, module, require) {
						eval("module.exports = TVE_Dash.views.Modal.extend( {\n\n\tinitialize: function ( args ) {\n\n\t\tif ( this.model.get( 'type' ) === 'monetary' && this.model.get( 'goal_pages' ) === 'sendowl' ) {\n\t\t\tthis.template = TVE_Dash.tpl( 'modals/goal/sendowl' );\n\t\t} else {\n\t\t\tthis.template = TVE_Dash.tpl( 'modals/goal/' + this.model.get( 'type' ) );\n\t\t}\n\n\t\tTVE_Dash.views.Modal.prototype.initialize.apply( this, arguments );\n\t},\n\n\trender: function () {\n\t\tTVE_Dash.views.Modal.prototype.render.apply( this, arguments );\n\n\t\tvar _tpl;\n\n\t\tif ( this.model.get( 'type' ) === 'monetary' ) {\n\t\t\t_tpl = TVE_Dash.tpl( 'modals/goal/revenue-row' );\n\t\t} else if ( this.model.get( 'type' ) === 'visits' ) {\n\t\t\t_tpl = TVE_Dash.tpl( 'modals/goal/page-row' );\n\t\t}\n\n\t\tif ( _tpl ) {\n\t\t\tthis.collection.each( function ( item ) {\n\t\t\t\tthis.$( '.thrive-ap-goal-pages' ).append( _tpl( {model: item} ) );\n\t\t\t}, this );\n\t\t}\n\n\t\treturn this;\n\t},\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/goal.js");
					},
					"test.js": function (exports, module, require) {
						eval("var optins_settings = require( '../views/goals/optins-settings' ),\n\tmonetary_settings = require( '../views/goals/monetary-settings' ),\n\tvisits_settings = require( '../views/goals/visits-settings' );\n\nmodule.exports = TVE_Dash.views.ModalSteps.extend( {\n\n\tclassName: 'tvd-modal tvd-modal-fixed-footer',\n\n\ttemplate: TVE_Dash.tpl( 'modals/html-test' ),\n\n\tevents: function () {\n\n\t\treturn _.extend( TVE_Dash.views.ModalSteps.prototype.events, {\n\n\t\t\t'click .tvd-modal-submit': 'submit',\n\t\t\t'click .thrive-ab-goal': function ( event ) {\n\n\t\t\t\tif ( event.currentTarget.classList.contains( 'thrive-ab-disabled' ) ) {\n\t\t\t\t\treturn false;\n\t\t\t\t}\n\n\t\t\t\tthis.$( \".thrive-ab-goal\" ).removeClass( \"thrive-ab-selected\" );\n\t\t\t\tevent.currentTarget.classList.add( \"thrive-ab-selected\" );\n\n\n\t\t\t\tjQuery( '.tvd-modal-content' ).animate( {\n\t\t\t\t\tscrollTop: jQuery( \"#thrive-ab-goal-settings\" ).offset().top\n\t\t\t\t}, 500 );\n\n\n\t\t\t\tthis.model.set( 'type', event.currentTarget.dataset.goal );\n\t\t\t}\n\t\t} );\n\t},\n\n\tinitialize: function ( args ) {\n\n\t\tTVE_Dash.views.ModalSteps.prototype.initialize.apply( this, arguments );\n\n\t\tthis.listenTo( this.model, 'change:type', this.render_goal_settings );\n\n\t\tthis.listenTo( this.model, 'change:auto_win_enabled', this.toggle_settings_input );\n\t},\n\n\tafterRender: function () {\n\n\t\tTVE_Dash.views.ModalSteps.prototype.afterRender.apply( this, arguments );\n\n\t\tTVE_Dash.data_binder( this );\n\n\t\tthis.toggle_settings_input();\n\n\t\tvar has_forms = this.model.get( 'items' ).where( {has_form: false} ).length > 0;\n\t},\n\n\tgotoStep: function ( index ) {\n\n\t\tTVE_Dash.views.ModalSteps.prototype.gotoStep.apply( this, arguments );\n\n\t\tvar _tabs = this.$step.find( '.tvd-tab' );\n\n\t\tif ( _tabs.length ) {\n\t\t\t_tabs.addClass( 'tvd-disabled' );\n\t\t\tjQuery( _tabs[ index ] ).removeClass( 'tvd-disabled' ).find( 'a' ).first().trigger( 'click' );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tbeforeNext: function () {\n\n\t\treturn this.model.isValid( {\n\t\t\tstep: this.currentStep\n\t\t} );\n\t},\n\n\ttoggle_settings_input: function () {\n\n\t\tif ( this.model.get( 'auto_win_enabled' ) === true ) {\n\t\t\tthis.$( '#auto-win-settings' ).show();\n\t\t} else {\n\t\t\tthis.model.set( this.model.defaults() );\n\t\t\tthis.$( '#auto-win-settings' ).hide();\n\t\t}\n\n\t},\n\n\trender_goal_settings: function () {\n\n\t\tvar _options = {\n\t\t\tmodel: this.model\n\t\t};\n\n\t\tdelete this.model.attributes.service;\n\n\t\tif ( this.goal_settings_view ) {\n\t\t\tthis.goal_settings_view.remove();\n\t\t}\n\n\t\tswitch ( this.model.get( 'type' ) ) {\n\t\t\tcase 'monetary':\n\t\t\t\tthis.goal_settings_view = new monetary_settings( _options );\n\t\t\t\tbreak;\n\t\t\tcase 'visits':\n\t\t\t\tthis.goal_settings_view = new visits_settings( _options );\n\t\t\t\tbreak;\n\t\t\tcase 'optins':\n\t\t\t\tthis.goal_settings_view = new optins_settings( _options );\n\t\t\t\tbreak;\n\t\t}\n\n\t\tthis.$( '#thrive-ab-goal-settings' ).html( this.goal_settings_view.render().$el );\n\t},\n\n\tsubmit: function () {\n\n\t\tif ( ! this.model.isValid() ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tTVE_Dash.showLoader( true );\n\n\t\tthis.model.save( null, {\n\t\t\tsuccess: _.bind( function () {\n\t\t\t\tlocation.href = ThriveAB.page.edit_link;\n\t\t\t}, this ),\n\t\t\terror: _.bind( function () {\n\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t\tTVE_Dash.err( 'Test could not be saved' );\n\t\t\t} )\n\t\t} );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/test.js");
					},
					"variation-winner.js": function (exports, module, require) {
						eval("module.exports = TVE_Dash.views.Modal.extend( {\n\n\tevents: {\n\t\t'click .tvd-modal-submit': function () {\n\t\t\tTVE_Dash.showLoader( true );\n\t\t\tlocation.reload();\n\t\t}\n\t},\n\n\ttemplate: TVE_Dash.tpl( 'modals/variation-winner' ),\n\n\tafterInitialize: function () {\n\n\t\tthis.model.set( 'label', TVE_Dash.sprintf( ThriveAB.t.variation_winner, this.model.get( 'title' ) ) );\n\n\t\t/**\n\t\t * add custom class to modal\n\t\t */\n\t\tthis.$el.addClass( 'thrive-ab-set-winner' );\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/variation-winner.js");
					},
					"winner.js": function (exports, module, require) {
						eval("var test_table = require( './../views/test/table' ),\n\tvariation_winner_modal = require( './variation-winner' );\n\nmodule.exports = TVE_Dash.views.Modal.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'modals/html-winner' ),\n\n\tafterInitialize: function () {\n\n\t\tthis.model.on( 'winner_selected', function ( test, item ) {\n\t\t\tthis.close();\n\t\t\tTVE_Dash.modal( variation_winner_modal, {\n\t\t\t\tmodel: item,\n\t\t\t\ttitle: '',\n\t\t\t\tno_close: true,\n\t\t\t\tdismissible: false\n\t\t\t} );\n\t\t}, this );\n\n\t\treturn this;\n\t},\n\n\tafterRender: function () {\n\n\t\tvar item_template_name = 'modals/winner/test/item/' + this.model.get( 'type' );\n\n\t\tvar test_view = new test_table( {\n\t\t\tmodel: this.model,\n\t\t\tcollection: this.collection,\n\t\t\titem_template_name: item_template_name\n\t\t} );\n\n\t\ttest_view.template = TVE_Dash.tpl( 'modals/winner/test/' + this.model.get( 'type' ) );\n\n\t\tthis.$( '#test-view' ).html( test_view.render().$el );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/modals/winner.js");
					}
				},
				"models": {
					"base.js": function (exports, module, require) {
						eval("(function ( $ ) {\n\tmodule.exports = Backbone.Model.extend( {\n\n\t\tidAttribute: 'ID',\n\n\t\tdefaults: function () {\n\t\t\treturn {\n\t\t\t\tID: ''\n\t\t\t}\n\t\t},\n\n\t\turl: function () {\n\n\t\t\tvar url = ThriveAB.ajax.get_url( this.get_action() + '&' + this.get_route() );\n\n\t\t\tif ( $.isNumeric( this.get( 'ID' ) ) ) {\n\t\t\t\turl += '&ID=' + this.get( 'ID' );\n\t\t\t}\n\n\t\t\treturn url;\n\t\t},\n\t\tget_action: function () {\n\n\t\t\treturn 'action=' + ThriveAB.ajax.controller_action;\n\t\t},\n\t\tget_route: function () {\n\n\t\t\treturn 'route=no_route';\n\t\t},\n\n\t\tvalidation_error: function ( field, message, callback ) {\n\n\t\t\treturn {\n\t\t\t\tfield: field,\n\t\t\t\tmessage: message,\n\t\t\t\tcallback: callback\n\t\t\t};\n\t\t}\n\t} );\n})( jQuery );\n//# sourceURL=ab-page-testing/assets/js/models/base.js");
					},
					"report-chart.js": function (exports, module, require) {
						eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 12/7/2017\n * Time: 9:57 AM\n */\n\nvar base = require( './base' );\n\nmodule.exports = base.extend( {\n\tdefaults: function () {\n\t\treturn _.extend( base.prototype.defaults(), {\n\t\t\tID: 0,\n\t\t\ttitle: '',\n\t\t\tx_axis: [],\n\t\t\ty_axis: ''\n\t\t} );\n\t},\n\tget_route: function () {\n\n\t\treturn 'route=report';\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/models/report-chart.js");
					},
					"test-item.js": function (exports, module, require) {
						eval("var base = require( './base' );\n\nmodule.exports = base.extend( {\n\n\tidAttribute: 'id',\n\n\tdefaults: function () {\n\t\treturn {\n\t\t\tid: '',\n\t\t\trevenue: 0\n\t\t};\n\t},\n\tget_route: function () {\n\n\t\treturn 'route=testitem';\n\n\t},\n\tvalidate: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\tif ( options.test instanceof Backbone.Model ) {\n\n\t\t\tvar test_type = options.test.get( 'type' ),\n\t\t\t\tvalidator_callback = 'validate_' + test_type;\n\n\t\t\tif ( test_type && typeof this[validator_callback] === 'function' ) {\n\t\t\t\t_errors = this[validator_callback]( attrs, options );\n\t\t\t}\n\t\t}\n\n\t\treturn _errors.length ? _errors : undefined;\n\t},\n\n\tvalidate_monetary: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\tif ( isNaN( parseFloat( attrs.revenue ) ) ) {\n\t\t\t_errors.push( this.validation_error( 'revenue', 'invalid revenue' ) );\n\t\t}\n\n\t\treturn _errors;\n\t},\n\n\tvalidate_visits: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\treturn _errors;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/models/test-item.js");
					},
					"test.js": function (exports, module, require) {
						eval("var base = require( './base' ),\n\tvariations_collection = require( '../collections/variations' ),\n\ttest_item_model = require( './test-item' ),\n\ttest_items_collection = require( '../collections/test-items' );\n\nmodule.exports = base.extend( {\n\n\tidAttribute: 'id',\n\n\tdefaults: function () {\n\t\tvar items = this.get( 'items' );\n\t\treturn _.extend( {}, {\n\t\t\tid: '',\n\t\t\tauto_win_enabled: 0,\n\t\t\tauto_win_min_conversions: items && items.length ? ( items.length - 1 ) * 100 : 100,\n\t\t\tauto_win_min_duration: 14,\n\t\t\tauto_win_chance_original: 95\n\t\t} );\n\t},\n\n\tget_route: function () {\n\n\t\treturn 'route=tests';\n\t},\n\n\tinitialize: function ( attrs ) {\n\n\t\tif ( ! attrs.items ) {\n\t\t\tthrow new Error( 'Test model must have items defined' );\n\t\t}\n\n\t\t/**\n\t\t * convert\n\t\t */\n\t\tif ( attrs.items instanceof variations_collection ) {\n\t\t\tvar items = [];\n\t\t\tattrs.items.each( function ( variation, index ) {\n\t\t\t\titems.push( {\n\t\t\t\t\tvariation_id: variation.get( 'ID' ),\n\t\t\t\t\ttitle: variation.get( 'post_title' ),\n\t\t\t\t\tis_control: variation.get( 'is_control' ) === true,\n\t\t\t\t\thas_form: variation.get( 'has_form' )\n\t\t\t\t} );\n\t\t\t} );\n\t\t\tthis.set( 'items', new test_items_collection( items ) );\n\t\t} else if ( attrs.items.length ) {\n\t\t\tthis.set( 'items', new test_items_collection( attrs.items ) );\n\t\t}\n\t},\n\n\tparse: function ( response ) {\n\n\t\tif ( response.items ) {\n\t\t\tresponse.items = new test_items_collection( response.items );\n\t\t}\n\n\t},\n\n\tvalidate: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\tif ( options.step !== undefined ) {\n\t\t\t_errors = _.union( _errors, this[ 'validate_step_' + options.step ].apply( this, arguments ) );\n\t\t\treturn _errors.length ? _errors : undefined;\n\t\t}\n\n\t\tif ( ! attrs.type ) {\n\t\t\t_errors.push( this.validation_error( 'type', '', function () {\n\t\t\t\tTVE_Dash.err( 'Select type' );\n\t\t\t} ) );\n\n\t\t\treturn _errors;\n\t\t}\n\n\t\tvar _type = attrs.type,\n\t\t\t_type_validation_method = 'validate_' + _type;\n\n\t\t//validate type dynamically\n\t\tif ( typeof  this[ _type_validation_method ] === 'function' ) {\n\n\t\t\t_errors = this[ _type_validation_method ]( attrs, options );\n\n\t\t\treturn _errors;\n\t\t}\n\n\t\treturn _errors.length ? _errors : undefined;\n\t},\n\n\tvalidate_monetary: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\t//validate if service set when user wants to start a test\n\t\t//it enters here too if user wants to change the winner settings for a running test\n\t\tif ( ! attrs.service && ! attrs.save_test_settings ) {\n\n\t\t\t_errors.push( this.validation_error( 'service', '', function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.select_measurement_option );\n\t\t\t} ) );\n\t\t}\n\n\t\tif ( 'visit_page' === attrs.service && ( ! attrs.goal_pages || Object.keys( attrs.goal_pages ).length === 0 ) ) {\n\t\t\t_errors.push( this.validation_error( 'goal_page', '', function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.select_thank_you_page );\n\t\t\t} ) );\n\t\t}\n\n\t\treturn _errors.length ? _errors : undefined;\n\t},\n\n\tvalidate_visits: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\tif ( ! attrs.goal_pages || Object.keys( attrs.goal_pages ).length === 0 ) {\n\t\t\t_errors.push( this.validation_error( 'goal_page', '', function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.select_goal_page );\n\t\t\t} ) );\n\t\t}\n\n\t\treturn _errors.length ? _errors : undefined;\n\t},\n\n\tvalidate_optins: function ( attrs, options ) {\n\n\t\tvar _errors = [];\n\n\t\treturn _errors.length ? _errors : undefined;\n\t},\n\n\tvalidate_step_winner_settings: function ( attrs, options ) {\n\n\t\tvar fields = {\n\t\t\tauto_win_min_conversions: attrs.auto_win_min_conversions,\n\t\t\tauto_win_min_duration: attrs.auto_win_min_duration,\n\t\t\tauto_win_chance_original: attrs.auto_win_chance_original\n\t\t};\n\n\t\treturn this._validate_fields( fields );\n\t},\n\n\t_validate_fields: function ( fields ) {\n\n\t\tvar _errors = [];\n\n\t\t/**\n\t\t * check if one of the fields has validator; if yes then and execute it and stack any error\n\t\t */\n\t\t_.each( fields, function ( value, prop ) {\n\t\t\tif ( typeof this[ 'validate_' + prop ] === 'function' ) {\n\t\t\t\t_errors = _.union( _errors, this[ 'validate_' + prop ]( value ) );\n\t\t\t}\n\t\t}, this );\n\n\t\tif ( _errors.length ) {\n\t\t\treturn _errors;\n\t\t}\n\t},\n\n\tvalidate_step_0: function ( attrs, options ) {\n\n\t\tvar fields = {\n\t\t\ttitle: attrs.title,\n\t\t\tauto_win_min_conversions: attrs.auto_win_min_conversions,\n\t\t\tauto_win_min_duration: attrs.auto_win_min_duration,\n\t\t\tauto_win_chance_original: attrs.auto_win_chance_original\n\t\t};\n\n\t\treturn this._validate_fields( fields );\n\t},\n\n\tvalidate_title: function ( value ) {\n\n\t\tif ( ! value ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'title', ThriveAB.t.invalid_test_title )\n\t\t\t];\n\t\t}\n\n\t\treturn [];\n\t},\n\n\tvalidate_auto_win_min_conversions: function ( value ) {\n\n\t\tif ( isNaN( parseInt( value ) ) ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_min_conversions', ThriveAB.t.not_number_min_win_conversions )\n\t\t\t];\n\t\t}\n\n\t\tif ( parseInt( value ) <= 0 ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_min_conversions', ThriveAB.t.greater_zero_min_win_conversions )\n\t\t\t];\n\t\t}\n\n\t\treturn [];\n\t},\n\n\tvalidate_auto_win_min_duration: function ( value ) {\n\n\t\tif ( isNaN( parseInt( value ) ) ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_min_duration', ThriveAB.t.invalid_auto_win_min_duration )\n\t\t\t];\n\t\t}\n\n\t\tif ( parseInt( value ) <= 0 ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_min_duration', ThriveAB.t.invalid_auto_win_min_duration )\n\t\t\t];\n\t\t}\n\n\t\treturn [];\n\t},\n\n\tvalidate_auto_win_chance_original: function ( value ) {\n\n\t\tif ( isNaN( parseInt( value ) ) ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_chance_original', ThriveAB.t.invalid_auto_win_chance_original )\n\t\t\t];\n\t\t}\n\n\t\tif ( parseInt( value ) <= 0 || parseInt( value ) > 100 ) {\n\t\t\treturn [\n\t\t\t\tthis.validation_error( 'auto_win_chance_original', ThriveAB.t.invalid_auto_win_chance_original )\n\t\t\t];\n\t\t}\n\n\t\treturn [];\n\t},\n\n\tsearch_page_label: function () {\n\n\t\tvar _label = 'Search Page',\n\t\t\t_type = this.get( 'type' );\n\n\t\tif ( _type === 'monetary' ) {\n\t\t\t_label = 'Thank you page'\n\t\t} else if ( _type === 'visits' ) {\n\t\t\t_label = 'Goal page';\n\t\t}\n\n\t\treturn _label;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/models/test.js");
					},
					"traffic.js": function (exports, module, require) {
						eval("var base = require( './base' );\n\nmodule.exports = base.extend( {\n\n\tget_route: function () {\n\n\t\treturn 'route=traffic';\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/models/traffic.js");
					},
					"variation.js": function (exports, module, require) {
						eval("var base = require( './base' );\n\nmodule.exports = base.extend( {\n\n\tdefaults: function () {\n\n\t\treturn _.extend( base.prototype.defaults(), {\n\t\t\tis_control: false,\n\t\t\ttraffic: 0\n\t\t} );\n\t},\n\n\tget_route: function () {\n\n\t\treturn 'route=variations';\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/models/variation.js");
					}
				},
				"router.js": function (exports, module, require) {
					eval("var reports = require( './views/report/report' ),\n\tvariation_collection = require( './collections/variations' ),\n\tdashboard = require( './views/dashboard' ),\n\ttest_model = require( './models/test' );\n\n(function ( $ ) {\n\n\tmodule.exports = Backbone.Router.extend( {\n\t\tview: null,\n\t\t$el: $( '#tab-dashboard-wrapper' ),\n\t\troutes: {\n\t\t\t'dashboard(/:action)': 'dashboard',\n\t\t\t'test(/:id)': 'reports'\n\t\t},\n\t\t/**\n\t\t * dashboard route callback\n\t\t */\n\t\tdashboard: function ( action ) {\n\t\t\tif ( this.view ) {\n\t\t\t\tthis.view.remove();\n\t\t\t}\n\n\t\t\tif ( typeof ThriveAB === 'undefined' ) {\n\t\t\t\tconsole.log( 'Thrive Optimize have not localized required data !' );\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tthis.view = new dashboard( {\n\t\t\t\tel: this.$el,\n\t\t\t\tmodel: new Backbone.Model( ThriveAB.page ),\n\t\t\t\tcollection: new variation_collection( ThriveAB.variations ),\n\t\t\t\tarchived: new variation_collection( ThriveAB.archived ),\n\t\t\t} );\n\n\t\t\tif ( action === 'start-test' ) {\n\t\t\t\tthis.view.$( '#thrive-ab-start-test' ).trigger( 'click' );\n\t\t\t}\n\t\t},\n\t\t/**\n\t\t * reports route callback\n\t\t */\n\t\treports: function ( id ) {\n\t\t\tif ( this.view ) {\n\t\t\t\tthis.view.remove();\n\t\t\t}\n\n\t\t\tvar model = new test_model( id ? ThriveAB.running_test : ThriveAB.current_test );\n\n\t\t\tthis.view = new reports( {\n\t\t\t\tel: this.$el,\n\t\t\t\tmodel: model\n\t\t\t} );\n\t\t}\n\t} );\n\n})( jQuery );\n//# sourceURL=ab-page-testing/assets/js/router.js");
				},
				"util.js": function (exports, module, require) {
					eval("(function ( $ ) {\n\n\tmodule.exports = {\n\t\tajax: {\n\t\t\tget_url: function ( query_string ) {\n\n\t\t\t\tvar _q = this.url.indexOf( '?' ) !== - 1 ? '&' : '?';\n\n\t\t\t\tif ( ! query_string || ! query_string.length ) {\n\t\t\t\t\treturn this.url + _q + '_nonce=' + this.nonce;\n\t\t\t\t}\n\n\t\t\t\tquery_string = query_string.replace( /^(\\?|&)/, '' );\n\t\t\t\tquery_string += '&nonce=' + this.nonce;\n\n\t\t\t\treturn this.url + _q + query_string;\n\t\t\t},\n\t\t\tdata: function ( custom_action, type, extra_data, data_type ) {\n\t\t\t\treturn {\n\t\t\t\t\turl: this.url,\n\t\t\t\t\tdataType: typeof data_type === 'undefined' ? 'json' : data_type,\n\t\t\t\t\ttype: type || 'get',\n\t\t\t\t\tdata: _.extend( {\n\t\t\t\t\t\taction: this.action,\n\t\t\t\t\t\tcustom: custom_action,\n\t\t\t\t\t\tnonce: this.nonce\n\t\t\t\t\t}, extra_data || {} ),\n\t\t\t\t\terror: function ( jqXHR, textStatus, errorThrown ) {\n\t\t\t\t\t\tif ( typeof jqXHR.tcb_error === 'function' && jqXHR.tcb_error.apply( jqXHR, arguments ) === false ) {\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tTVE_Dash.hideLoader();\n\n\t\t\t\t\t\tif ( jqXHR.responseText ) {\n\t\t\t\t\t\t\ttry {\n\t\t\t\t\t\t\t\tvar response = JSON.parse( jqXHR.responseText );\n\t\t\t\t\t\t\t\tTVE_Dash.err( response.message );\n\t\t\t\t\t\t\t} catch ( e ) {\n\t\t\t\t\t\t\t\tTVE_Dash.err( jqXHR.responseText );\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\treturn;\n\t\t\t\t\t\t}\n\t\t\t\t\t\tif ( ! errorThrown ) {\n\t\t\t\t\t\t\terrorThrown = 'An unexpected error occurred. ' + ( jqXHR.status ? ' (Status code: ' + jqXHR.status + ')' : '' );\n\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\terrorThrown = 'Unexpected error: ' + ( jqXHR.status ? jqXHR.status + ': ' : '' ) + errorThrown;\n\t\t\t\t\t\t}\n\t\t\t\t\t\t// finally just the error text\n\t\t\t\t\t\tTVE_Dash.err( errorThrown );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tdo: function ( action, type, extra_data, data_type ) {\n\t\t\t\treturn $.ajax( this.data( action, type, extra_data, data_type ) );\n\t\t\t}\n\t\t}\n\t};\n})( jQuery );\n//# sourceURL=ab-page-testing/assets/js/util.js");
				},
				"views": {
					"archived_variation.js": function (exports, module, require) {
						eval("var base = require( './base' ),\n\tdelete_modal = require( '../modals/delete' );\n\nmodule.exports = base.extend( {\n\n\tclassName: 'tvd-col tvd-l3 tvd-m6',\n\n\ttemplate: TVE_Dash.tpl( 'html-archived-variation-card' ),\n\tinitialize: function ( args ) {\n\t\tbase.prototype.initialize.apply( this, args );\n\t\tthis.published_variations = args.published_variations;\n\t\tthis.archived_variations = args.archived_variations;\n\t},\n\n\tdelete: function () {\n\n\t\tTVE_Dash.modal( delete_modal, {\n\t\t\tsubmit: _.bind( function () {\n\t\t\t\tthis.remove();\n\t\t\t\tthis.model.destroy();\n\t\t\t}, this ),\n\t\t\tmodel: this.model,\n\t\t\tbtn_yes_txt: ThriveAB.t.delete_title,\n\t\t\tbtn_no_txt: ThriveAB.t.cancel,\n\t\t\ttitle: ThriveAB.t.delete_variation,\n\t\t\tdescription: TVE_Dash.sprintf( ThriveAB.t.about_to_delete, this.model.get( 'post_title' ) )\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\trestore: function () {\n\t\tvar self = this;\n\t\tthis.model.set( 'action', 'publish' );\n\t\tTVE_Dash.showLoader();\n\t\tthis.model.save( null, {\n\t\t\tsuccess: function ( model ) {\n\t\t\t\tmodel.collection = self.published_variations;\n\t\t\t\tself.published_variations.add( model );\n\t\t\t\tself.published_variations.equalize_traffic();\n\t\t\t\tself.published_variations.save_distributed_traffic();\n\t\t\t\tself.remove();\n\t\t\t\tself.archived_variations.remove( model );\n\t\t\t\tTVE_Dash.success( ThriveAB.t.variation_added, 1000 );\n\t\t\t},\n\t\t\terror: function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.add_variation_error );\n\t\t\t},\n\t\t\tcomplete: function () {\n\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t}\n\t\t} );\n\t},\n\n\trender: function () {\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/views/archived_variation.js");
					},
					"base.js": function (exports, module, require) {
						eval("/**\n * @description Base View\n * @extends Backbone.View\n */\nmodule.exports = Backbone.View.extend( {\n\n\tevents: {\n\t\t'click .click': '_call',\n\t\t'input .input': '_call',\n\t\t'change .change': '_call',\n\t\t'mousedown .mousedown': '_call',\n\t\t'mouseenter .mouseenter': '_call',\n\t\t'mouseup .mouseup': '_call',\n\t\t'keyup .keyup-enter': '_keyup_enter'\n\t},\n\n\tinitialize: function () {\n\n\t\tthis.render();\n\t},\n\n\t_call: function ( e ) {\n\t\t/**\n\t\t * Do not allow actions on disabled controls\n\t\t */\n\t\tif ( e.currentTarget.disabled || e.currentTarget.classList.contains( 'tve-disabled' ) ) {\n\t\t\treturn false;\n\t\t}\n\n\t\tvar m = e.currentTarget.getAttribute( 'data-fn-' + e.type ) || e.currentTarget.getAttribute( 'data-fn' );\n\n\t\tif ( m && m === '__return_false' ) {\n\t\t\te.stopPropagation();\n\t\t\te.preventDefault();\n\t\t\treturn false;\n\t\t}\n\n\t\tif ( typeof this[m] === 'function' ) {\n\t\t\treturn this[m].call( this, e, e.currentTarget );\n\t\t}\n\n\t\t/**\n\t\t * call external function on the base TVE object\n\t\t */\n\t\tif ( m && m.indexOf( 'f:' ) === 0 ) {\n\t\t\tvar fn = TVE, parts = m.split( ':' )[1].split( '.' ), context = window;\n\t\t\twhile ( fn && parts.length ) {\n\t\t\t\tcontext = fn;\n\t\t\t\tfn = fn[parts.shift()];\n\t\t\t}\n\t\t\tif ( typeof fn === 'function' ) {\n\t\t\t\treturn fn.call( context, e );\n\t\t\t}\n\t\t}\n\t},\n\n\trender: function () {\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/views/base.js");
					},
					"charts": {
						"line-chart.js": function (exports, module, require) {
							eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 12/5/2017\n * Time: 10:56 AM\n */\n\nmodule.exports = Backbone.Model.extend( {\n\tdefaults: function () {\n\t\treturn {\n\t\t\tid: '',\n\t\t\ttitle: '',\n\t\t\trenderTo: '',\n\t\t\ttype: 'line',\n\t\t\tsuffix: '',\n\t\t\tdata: []\n\t\t};\n\t},\n\tinitialize: function () {\n\t\tvar title = this.get( 'title' ),\n\t\t\ttype = this.get( 'type' ),\n\t\t\trenderTo = this.get( 'renderTo' );\n\t\tthis.chart = this.dochart( title, type, renderTo );\n\t},\n\tempty: function () {\n\t\twhile ( this.chart.series.length > 0 ) {\n\t\t\tthis.chart.series[0].remove( true );\n\t\t}\n\t},\n\tredraw: function () {\n\t\tvar title = this.get( 'title' ),\n\t\t\tdata = this.get( 'data' ),\n\t\t\tx_axis = this.get( 'x_axis' ),\n\t\t\ty_axis = this.get( 'y_axis' ),\n\t\t\tids = [],\n\t\t\tx_axis_length = this.get( 'x_axis' ).length;\n\n\t\t//add series or update data if it already exists\n\t\tfor ( var i in data ) {\n\t\t\tids.push( data[i].id );\n\t\t\tvar series = this.chart.get( data[i].id );\n\t\t\tif ( ! series ) {\n\t\t\t\tthis.chart.addSeries( data[i], false, false )\n\t\t\t} else {\n\t\t\t\tseries.setData( data[i].data );\n\t\t\t}\n\t\t}\n\t\t//delete old series\n\t\tfor ( i = 0; i < this.chart.series.length; i ++ ) {\n\t\t\tif ( ids.indexOf( this.chart.series[i].options.id ) < 0 ) {\n\t\t\t\tthis.chart.series[i].remove( false );\n\t\t\t\ti --;\n\t\t\t}\n\t\t}\n\n\t\tthis.chart.get( 'time_interval' ).setCategories( x_axis );\n\t\tthis.chart.xAxis[0].update( {\n\t\t\ttickInterval: x_axis_length > 13 ? Math.ceil( x_axis_length / 13 ) : 1\n\t\t} );\n\n\t\tthis.chart.setTitle( {text: title} );\n\t\tif ( this.chart.yAxis[0].axisTitle ) {\n\t\t\tthis.chart.yAxis[0].axisTitle.attr( {\n\t\t\t\ttext: y_axis\n\t\t\t} );\n\t\t}\n\t\tthis.chart.redraw();\n\t\tthis.chart.hideLoading();\n\t},\n\tshowLoading: function () {\n\t\tthis.chart.showLoading();\n\t},\n\thideLoading: function () {\n\t\tthis.chart.hideLoading();\n\t},\n\tdochart: function ( title, type, renderTo ) {\n\t\tvar self = this;\n\n\t\treturn new Highcharts.Chart( {\n\t\t\tchart: {\n\t\t\t\ttype: type,\n\t\t\t\trenderTo: renderTo,\n\t\t\t\tstyle: {\n\t\t\t\t\tfontFamily: 'Open Sans,sans-serif'\n\t\t\t\t}\n\t\t\t},\n\t\t\tcolors: ThriveAB.chart_colors,\n\t\t\tyAxis: {\n\t\t\t\tallowDecimals: false,\n\t\t\t\ttitle: {\n\t\t\t\t\ttext: 'Engagements'\n\t\t\t\t},\n\t\t\t\tmin: 0\n\t\t\t},\n\t\t\txAxis: {\n\t\t\t\tid: 'time_interval'\n\t\t\t},\n\t\t\tcredits: {\n\t\t\t\tenabled: false\n\t\t\t},\n\t\t\ttitle: {\n\t\t\t\ttext: title\n\t\t\t},\n\t\t\ttooltip: {\n\t\t\t\tshared: false,\n\t\t\t\tuseHTML: true,\n\t\t\t\tformatter: function () {\n\t\t\t\t\tif ( this.series.type == 'scatter' ) {\n\t\t\t\t\t\t/* We don't display tooltips for the scatter graph */\n\t\t\t\t\t\treturn false;\n\t\t\t\t\t} else {\n\t\t\t\t\t\treturn this.x + '<br/>' +\n\t\t\t\t\t\t       this.series.name + ': ' + '<b>' + this.y + '</b>' + self.get( 'suffix' );\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t},\n\t\t\tplotOptions: {\n\t\t\t\tseries: {\n\t\t\t\t\tdataLabels: {\n\t\t\t\t\t\tshape: 'callout',\n\t\t\t\t\t\tbackgroundColor: 'rgba(0, 0, 0, 0.75)',\n\t\t\t\t\t\tstyle: {\n\t\t\t\t\t\t\tcolor: '#FFFFFF',\n\t\t\t\t\t\t\ttextShadow: 'none'\n\t\t\t\t\t\t}\n\t\t\t\t\t},\n\t\t\t\t\tevents: {\n\t\t\t\t\t\tlegendItemClick: function () {\n\t\t\t\t\t\t\tif ( this.type == 'scatter' ) {\n\t\t\t\t\t\t\t\t/* The labels are not hidden by clicking on the legend so we have to do it manually */\n\t\t\t\t\t\t\t\tif ( this.visible ) {\n\t\t\t\t\t\t\t\t\tjQuery( '.highcharts-data-labels' ).hide();\n\t\t\t\t\t\t\t\t} else {\n\t\t\t\t\t\t\t\t\tjQuery( '.highcharts-data-labels' ).show();\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t} );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/charts/line-chart.js");
						}
					},
					"dashboard.js": function (exports, module, require) {
						eval("var base_view = require( './base' ),\n\tvariation_view = require( './variation' ),\n\tarchived_variation_view = require( './archived_variation' ),\n\ttest_model = require( '../models/test' ),\n\tvariation_model = require( '../models/variation' ),\n\tmodal_test = require( '../modals/test' );\n\nmodule.exports = base_view.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'dashboard/dashboard' ),\n\n\tinitialize: function ( args ) {\n\t\tthis.archived = args.archived;\n\n\t\tbase_view.prototype.initialize.apply( this, arguments );\n\n\t\tthis.listenTo( this.collection, 'add', function ( model ) {\n\t\t\tthis.render_variation( model );\n\t\t\tthis.render_action_button();\n\t\t\tthis.toggle_traffic_control();\n\t\t} );\n\t\tthis.listenTo( this.collection, 'remove', function ( model ) {\n\t\t\tthis.render_action_button();\n\t\t\tthis.toggle_traffic_control();\n\t\t} );\n\n\t\tthis.listenTo( this.archived, 'add', function ( model ) {\n\t\t\tthis.render_archived_variation( model );\n\t\t} );\n\t},\n\n\trender_action_button: function () {\n\t\tthis.$( '#thrive-ab-start-test' ).toggleClass( 'top-hide-action', this.collection.length < 2 );\n\t\tthis.$( '.thrive-ab-display-archived-container' ).toggleClass( 'hide', this.archived.length < 1 );\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template() );\n\t\tthis.$list = this.$( '#thrive-ab-card-list' );\n\t\tthis.$archived_list = this.$( '#thrive-ab-card-list-archived' );\n\n\t\tthis.render_action_button();\n\t\tthis.collection.each( function ( item, index, list ) {\n\t\t\tthis.render_variation( item );\n\t\t}, this );\n\n\t\tthis.archived.each( function ( item, index, list ) {\n\t\t\tthis.render_archived_variation( item );\n\t\t}, this );\n\t},\n\n\trender_archived_variation: function ( item ) {\n\t\tvar _view = new archived_variation_view( {\n\t\t\tmodel: item,\n\t\t\tarchived_variations: this.archived,\n\t\t\tpublished_variations: this.collection\n\t\t} );\n\t\tthis.$archived_list.append( _view.$el );\n\t},\n\n\trender_variation: function ( item ) {\n\n\t\tvar _view = new variation_view( {\n\t\t\tmodel: item,\n\t\t\tarchived_variations: this.archived,\n\t\t\tpublished_variations: this.collection\n\t\t} );\n\n\t\tvar $add_new_card = this.$list.find( '> .tvd-col' ).last();\n\t\t$add_new_card.remove();\n\n\t\tthis.$list.append( _view.$el );\n\t\tthis.$list.append( $add_new_card );\n\t},\n\n\tdisplay_archived: function () {\n\t\tthis.$archived_list.toggle();\n\t\tthis.$( '.thrive-ab-display-archived' ).toggleClass( 'active' );\n\t},\n\n\tadd_new_variation: function () {\n\n\t\tvar _new_traffic = parseInt( 100 / ( this.collection.length + 1 ) ),\n\t\t\t_model = new variation_model( {\n\t\t\t\tpost_parent: this.model.get( 'ID' ),\n\t\t\t\tpost_title: TVE_Dash.sprintf( ThriveAB.t.variation_no, this.collection.length + 1 ),\n\t\t\t\ttraffic: _new_traffic\n\t\t\t} );\n\n\t\tTVE_Dash.showLoader();\n\n\t\t_model.save( null, {\n\t\t\tsuccess: _.bind( function ( model ) {\n\t\t\t\tthis.collection.add( model );\n\t\t\t\tmodel.collection.distribute_traffic( model );\n\t\t\t\tmodel.collection.save_distributed_traffic();\n\t\t\t\tTVE_Dash.success( ThriveAB.t.variation_added, 1000 );\n\t\t\t}, this ),\n\t\t\terror: function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.add_variation_error );\n\t\t\t},\n\t\t\tcomplete: _.bind( function () {\n\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t}, this )\n\t\t} );\n\t},\n\n\tstart_test: function () {\n\n\t\tvar new_test_model = new test_model( {\n\t\t\tpage_id: ThriveAB.page.ID,\n\t\t\titems: this.collection\n\t\t} );\n\n\t\tTVE_Dash.modal( modal_test, {\n\t\t\tmodel: new_test_model,\n\t\t\t'max-width': '80%'\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\ttoggle_traffic_control: function () {\n\t\tif ( this.collection.length === 1 ) {\n\t\t\tthis.$( '.thrive-ab-card-footer input' ).attr( 'disabled', 'disabled' );\n\t\t} else {\n\t\t\tthis.$( '.thrive-ab-card-footer input' ).removeAttr( 'disabled' );\n\t\t}\n\t},\n\tequalize_traffic: function () {\n\t\tthis.collection.equalize_traffic();\n\t\tthis.collection.save_distributed_traffic();\n\n\t\treturn false;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/dashboard.js");
					},
					"goals": {
						"goal_page.js": function (exports, module, require) {
							eval("var base_view = require( '../base' ),\n\tpage_search = require( './../../controls/page_search' );\n\nmodule.exports = base_view.extend( {\n\n\tclassName: 'test-item-form tvd-col tvd-s12',\n\n\ttemplate: TVE_Dash.tpl( 'goals/page' ),\n\n\ttype: null,\n\tevents: {\n\t\t'click .thrive-ab-remove-page': 'remove_page'\n\t},\n\tinitialize: function ( args ) {\n\n\t\tif ( args.test && args.test instanceof Backbone.Model ) {\n\t\t\tthis.test = args.test\n\t\t}\n\t\tthis.model.set('type', this.test.get('type'));\n\t\tthis.page_search_view = new page_search.view( {\n\t\t\tmodel: this.model,\n\t\t\tgoal_pages: this.test.get('goal_pages')\n\t\t} );\n\n\t\tthis.page_search_view.test = this.test;\n\n\t\tthis.goal_pages = this.test.get( 'goal_pages' );\n\t\tif ( ! this.goal_pages ) {\n\t\t\tthis.goal_pages = {};\n\t\t}\n\n\t\tthis.listenTo( this.model, 'change:revenue', this.onRevenueChange );\n\t\tthis.listenTo( this.model, 'change:post_id', this.onPostChange );\n\n\t},\n\tonPostChange: function () {\n\t\tif ( this.model.get( 'post_id' ) != null ) {\n\t\t\tthis.goal_pages[this.model.get( 'post_id' )] = {\n\t\t\t\tpost_id: this.model.get( 'post_id' ),\n\t\t\t\tpost_title: this.model.get( 'post_title' ),\n\t\t\t\trevenue: this.model.get( 'revenue' )\n\t\t\t};\n\n\t\t\tthis.test.set( 'goal_pages', this.goal_pages );\n\t\t}\n\t},\n\tonRevenueChange: function () {\n\t\tif ( this.model.get( 'post_id' ) ) {\n\t\t\tthis.onPostChange();\n\t\t}\n\t},\n\trender: function () {\n\t\tthis.$el.html( this.template( {item: this.page_search_view.model, test: this.test} ) );\n\n\t\tsetTimeout( _.bind( function () {\n\t\t\tTVE_Dash.materialize( this.$el );\n\t\t}, this ), 0 );\n\n\t\tTVE_Dash.data_binder( this );\n\n\t\tthis.$( '.page-search' ).html( this.page_search_view.render().$el );\n\n\t\treturn this;\n\t},\n\tremove_page: function () {\n\t\tdelete this.goal_pages[this.model.get( 'post_id' )];\n\t\tthis.test.set( 'goal_pages', this.goal_pages );\n\t\tthis.$el.unbind();\n\t\tthis.remove();\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/goals/goal_page.js");
						},
						"monetary-settings.js": function (exports, module, require) {
							eval("var settings = require( './settings' );\n\n( function ( $ ) {\n\n\tmodule.exports = settings.extend( {\n\n\t\ttemplate: TVE_Dash.tpl( 'goals/monetary-settings' ),\n\n\t\tevents: function () {\n\n\t\t\tvar parent_settings = settings.prototype.events.apply( this, arguments );\n\n\t\t\treturn _.extend( parent_settings, {\n\t\t\t\t'change #thrive-ab-monetary-services': 'on_service_change'\n\t\t\t} );\n\n\t\t},\n\n\t\trender: function () {\n\n\t\t\tthis.$el.html( this.template( {item: this.model} ) );\n\n\t\t\tthis.$( '.thrive-ab-monetary-service' ).hide();\n\n\t\t\tthis.init_services();\n\n\t\t\tthis.render_goal_pages();\n\n\t\t\treturn this;\n\t\t},\n\n\t\ton_service_change: function ( event ) {\n\n\t\t\tvar $services = this.$( '.thrive-ab-monetary-service' ),\n\t\t\t\tservice = event.currentTarget.value;\n\n\t\t\t$services.hide();\n\n\t\t\tthis.model.set( 'service', service );\n\n\t\t\tif ( service.length <= 0 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\t$services.closest( '#' + service ).css( 'display', 'block' );\n\t\t},\n\n\t\tinit_services: function () {\n\n\t\t\tif ( typeof ThriveAB.monetary_services === 'undefined' || ThriveAB.monetary_services.length <= 0 ) {\n\t\t\t\treturn;\n\t\t\t}\n\n\t\t\tvar $dropdown = this.$( '#thrive-ab-monetary-services' ),\n\t\t\t\tservices = Object.keys( ThriveAB.monetary_services );\n\n\t\t\t_.each( ThriveAB.monetary_services, function ( service, slug ) {\n\t\t\t\tvar $option = $( '<option/>' )\n\t\t\t\t\t.attr( 'value', slug )\n\t\t\t\t\t.text( typeof service.label ? service.label : slug );\n\t\t\t\t$dropdown.append( $option );\n\t\t\t}, this );\n\n\t\t\tif ( services.length === 1 ) {\n\t\t\t\t$dropdown.val( services[ 0 ] ).change();\n\t\t\t\t$dropdown.parents( '.tvd-row' ).first().hide();\n\t\t\t}\n\t\t}\n\t} );\n\n} )( jQuery );\n//# sourceURL=ab-page-testing/assets/js/views/goals/monetary-settings.js");
						},
						"optins-settings.js": function (exports, module, require) {
							eval("var base_view = require( '../base' );\n\nmodule.exports = base_view.extend( {\n\ttemplate: TVE_Dash.tpl( 'goals/optins-settings' ),\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template() );\n\n\t\treturn this;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/goals/optins-settings.js");
						},
						"settings.js": function (exports, module, require) {
							eval("var base_view = require( '../base' ),\n\tgoal_page = require( './goal_page' ),\n\tbase_model = require( './../../models/base' ),\n\tpage_search = require( '../../controls/page_search' );\n\nmodule.exports = base_view.extend( {\n\n\tclassName: 'tvd-col tvd-s12',\n\n\tevents: function () {\n\t\treturn _.extend( base_view.prototype.events, {\n\t\t\t'click .thrive-ab-add-new-goal': 'add_goal_page_field'\n\t\t} );\n\t},\n\n\tinitialize: function () {\n\t\tthis.item_form_views = [];\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\n\t\tthis.render_goal_pages();\n\n\t\treturn this;\n\t},\n\n\trender_goal_pages: function () {\n\n\t\tvar goal_pages = this.model.get( 'goal_pages' ),\n\t\t\tform_view,\n\t\t\tself = this;\n\t\tif ( goal_pages ) {\n\t\t\t_.each( goal_pages, function ( element, index ) {\n\t\t\t\tform_view = new goal_page( {\n\t\t\t\t\ttest: self.model,\n\t\t\t\t\tmodel: new base_model( element )\n\t\t\t\t} );\n\n\t\t\t\tself.item_form_views.push( form_view );\n\n\t\t\t\tself.$( '#item-forms' ).append( self.create_goal_page( form_view ) );\n\t\t\t} );\n\t\t} else {\n\t\t\tthis.add_goal_page_field();\n\t\t}\n\n\t},\n\tadd_goal_page_field: function () {\n\n\t\tvar form_view = new goal_page( {\n\t\t\ttest: this.model,\n\t\t\tmodel: new base_model()\n\t\t} );\n\n\t\tthis.item_form_views.push( form_view );\n\n\t\tthis.$( '#item-forms' ).append( this.create_goal_page( form_view ) );\n\t},\n\tcreate_goal_page: function ( input_view ) {\n\n\t\treturn input_view.render().$el;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/goals/settings.js");
						},
						"visits-settings.js": function (exports, module, require) {
							eval("var settings = require( './settings' );\n\nmodule.exports = settings.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'goals/visits-settings' )\n} );\n//# sourceURL=ab-page-testing/assets/js/views/goals/visits-settings.js");
						}
					},
					"report": {
						"report-chart.js": function (exports, module, require) {
							eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 11/29/2017\n * Time: 11:42 AM\n */\n\nvar base_view = require( '../base' ),\n\tline_chart = require( '../charts/line-chart' );\n\nmodule.exports = base_view.extend( {\n\tcurrent_interval: 'day',\n\ttype: 'conversion_rate',\n\trender_to: '',\n\tinitialize: function ( options ) {\n\t\tbase_view.prototype.initialize.apply( this, arguments );\n\t\tthis.render_to = options.render_to;\n\n\t\tthis.update_chart();\n\t},\n\tdraw_chart: function ( render_to ) {\n\t\tthis.chart = new line_chart( {\n\t\t\ttitle: '',\n\t\t\ttype: 'spline',\n\t\t\tdata: [],\n\t\t\trenderTo: render_to\n\t\t} );\n\t\tthis.chart.showLoading();\n\t},\n\tinterval_changed: function ( type, interval ) {\n\t\tvar self = this;\n\n\t\tif ( interval === this.current_interval && type === this.type ) {\n\t\t\treturn;\n\t\t}\n\n\t\tthis.current_interval = interval;\n\t\tthis.type = type;\n\n\t\tif ( typeof this.chart !== 'undefined' ) {\n\t\t\tthis.chart.showLoading();\n\t\t}\n\n\t\tthis.model.fetch( {\n\t\t\tdata: jQuery.param( {\n\t\t\t\ttype: type,\n\t\t\t\tinterval: interval\n\t\t\t} ),\n\t\t\tsuccess: function () {\n\t\t\t\tself.update_chart();\n\t\t\t}\n\t\t} );\n\t},\n\tupdate_chart: function () {\n\t\tif ( typeof this.chart === 'undefined' ) {\n\t\t\tthis.draw_chart( this.render_to );\n\t\t}\n\t\tthis.chart.set( 'data', this.model.get( 'data' ) );\n\t\tthis.chart.set( 'title', '' );\n\t\tthis.chart.set( 'x_axis', this.model.get( 'x_axis' ) );\n\t\tthis.chart.set( 'y_axis', this.model.get( 'y_axis' ) );\n\n\t\tthis.chart.redraw();\n\n\t\tthis.update_description();\n\n\t},\n\tupdate_description: function () {\n\t\tthis.$( '#thrive-ab-chart-title' ).html( this.model.get( 'title' ) );\n\t\tthis.$( '#thrive-ab-chart-total-value' ).html( this.model.get( 'total_over_time' ) + ' ' + this.model.get( 'test_type_txt' ) );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/report/report-chart.js");
						},
						"report-item.js": function (exports, module, require) {
							eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 11/27/2017\n * Time: 2:31 PM\n */\n\nvar base_view = require( '../base' );\n\nmodule.exports = base_view.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'report/report-item' ),\n\n\ttagName: 'tr',\n\n\tinitialize: function () {\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {model: this.model} ) );\n\n\t\treturn this;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/report/report-item.js");
						},
						"report.js": function (exports, module, require) {
							eval("/**\n * Created by PhpStorm.\n * User: Ovidiu\n * Date: 11/27/2017\n * Time: 10:20 AM\n */\n\nvar base_view = require( '../base' ),\n\treport_item_view = require( './report-item' ),\n\treport_chart = require( './report-chart' ),\n\tchart_model = require( './../../models/report-chart' ),\n\ttest_table_view = require( './../test/table' ),\n\twinner_modal = require( './../../modals/winner' );\n\nmodule.exports = base_view.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'report/report' ),\n\n\tinitialize: function () {\n\t\tbase_view.prototype.initialize.apply( this, arguments );\n\t},\n\n\trender: function () {\n\t\tthis.$el.html( this.template( {\n\t\t\tmodel: this.model,\n\t\t\tedit_page_link: ThriveAB.page.edit_link\n\t\t} ) );\n\n\t\tthis.$( 'select' ).select2();\n\n\t\tvar table_view = new test_table_view( {\n\t\t\tel: this.$( '#thrive-ab-test' ),\n\t\t\tmodel: this.model\n\t\t} );\n\n\t\tthis.do_chart();\n\t},\n\tupdate_chart: function ( event, dom ) {\n\t\tvar type = this.$( '.tab-graph-type' ).val(),\n\t\t\tinterval = this.$( '.tab-graph-interval' ).val();\n\t\tthis.report_chart.interval_changed( type, interval );\n\t},\n\tdo_chart: function () {\n\t\tthis.report_chart = new report_chart( {\n\t\t\tel: this.$el,\n\t\t\tmodel: new chart_model( ThriveAB.test_chart ),\n\t\t\trender_to: 'tab-test-chart'\n\t\t} );\n\t},\n\tstop_test: function () {\n\n\t\tTVE_Dash.modal( winner_modal, {\n\t\t\tmodel: this.model,\n\t\t\tcollection: this.collection,\n\t\t\t'max-width': '80%',\n\t\t\twidth: '80%',\n\t\t\ttitle: ThriveAB.t.choose_winner\n\t\t} );\n\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/report/report.js");
						}
					},
					"test": {
						"goal.js": function (exports, module, require) {
							eval("var base = require( '../base' );\n\nmodule.exports = base.extend( {\n\tinitialize: function () {\n\t\tthis.template = TVE_Dash.tpl( 'test/item/goal/' + this.model.get( 'type' ) );\n\t},\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {} ) );\n\n\t\treturn this;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/test/goal.js");
						},
						"item.js": function (exports, module, require) {
							eval("var base = require( './../base' ),\n\tstop_variation_modal = require( './../../modals/delete' ),\n\trange = require( '../../controls/range' ),\n\tvariation_winner_modal = require( './../../modals/variation-winner' );\n\nmodule.exports = base.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'test/item/view' ),\n\tclassName: '',\n\n\tinitialize: function ( attrs ) {\n\t\tthis.active_items = attrs.active_items;\n\t\tthis.stopped_items = attrs.stopped_items;\n\t\tthis.table_model = attrs.table_model;\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {\n\t\t\titem: this.model,\n\t\t\ttable_model: this.table_model\n\t\t} ) );\n\n\t\tif ( this.className.length > 0 ) {\n\t\t\tthis.$el.attr( 'class', this.className );\n\t\t}\n\n\t\tif ( parseInt( this.model.get( 'active' ) ) !== 0 ) {\n\t\t\tnew range( {\n\t\t\t\tel: this.$( '.thrive-ab-test-item-traffic' ),\n\t\t\t\t/**\n\t\t\t\t * because the active_items is a collection with active items too\n\t\t\t\t * model.item is from whole collection of test items\n\t\t\t\t */\n\t\t\t\tmodel: this.active_items.findWhere( {id: this.model.get( 'id' )} )\n\t\t\t} );\n\t\t}\n\n\t\treturn this;\n\t},\n\n\tset_as_winner: function ( model, callback ) {\n\n\t\tif ( ! (model instanceof Backbone.Model) ) {\n\t\t\tmodel = this.model;\n\t\t}\n\n\t\tTVE_Dash.showLoader( true );\n\n\t\tThriveAB.ajax.do( 'set_winner', 'post', model.toJSON() )\n\t\t        .done( _.bind( function () {\n\n\t\t\t        if ( typeof callback === 'function' ) {\n\t\t\t\t        callback( model );\n\t\t\t        } else {\n\t\t\t\t        this.table_model.trigger( 'winner_selected', this.table_model, model );\n\t\t\t\t        TVE_Dash.hideLoader();\n\t\t\t        }\n\n\t\t        }, this ) );\n\n\t\treturn false;\n\t},\n\n\tstop_variation: function () {\n\n\t\tTVE_Dash.modal( stop_variation_modal, {\n\t\t\tsubmit: _.bind( function () {\n\t\t\t\tTVE_Dash.showLoader();\n\n\t\t\t\tthis.model.set( 'stop_test_item', true );\n\n\t\t\t\tthis.model.save( null, {\n\t\t\t\t\twait: true,\n\t\t\t\t\t/**\n\t\t\t\t\t * tell server to stop the item and return the item model to update the backbone model\n\t\t\t\t\t */\n\t\t\t\t\tsuccess: _.bind( function ( model ) {\n\n\t\t\t\t\t\t/**\n\t\t\t\t\t\t * split the removed traffic and save it\n\t\t\t\t\t\t */\n\t\t\t\t\t\tthis.active_items.split_traffic( model, model.previousAttributes().traffic );\n\t\t\t\t\t\tthis.active_items.save_distributed_traffic();\n\n\t\t\t\t\t\t/**\n\t\t\t\t\t\t * remove vew from active items list\n\t\t\t\t\t\t */\n\t\t\t\t\t\tthis.remove();\n\n\t\t\t\t\t\t/**\n\t\t\t\t\t\t * add to stopped items to be rendered\n\t\t\t\t\t\t */\n\t\t\t\t\t\tthis.stopped_items.add( model );\n\n\t\t\t\t\t\t/**\n\t\t\t\t\t\t * remove it from active collection items\n\t\t\t\t\t\t * so splitting traffic will not take into consideration this item/model\n\t\t\t\t\t\t */\n\t\t\t\t\t\tthis.active_items.remove( model );\n\n\t\t\t\t\t\tvar index = ThriveAB.current_test.items.findIndex( function ( element ) {\n\t\t\t\t\t\t\treturn element.id == model.get( 'id' );\n\t\t\t\t\t\t} );\n\t\t\t\t\t\tif ( index >= 0 ) {\n\t\t\t\t\t\t\tThriveAB.current_test.items[index].active = 0;\n\t\t\t\t\t\t}\n\n\t\t\t\t\t\tif ( this.active_items.length === 1 ) {\n\t\t\t\t\t\t\tthis.set_as_winner( this.active_items.first(), function ( model ) {\n\t\t\t\t\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t\t\t\t\t\tTVE_Dash.modal( variation_winner_modal, {\n\t\t\t\t\t\t\t\t\t\tmodel: model,\n\t\t\t\t\t\t\t\t\t\ttitle: '',\n\t\t\t\t\t\t\t\t\t\tno_close: true,\n\t\t\t\t\t\t\t\t\t\tdismissible: false\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t);\n\t\t\t\t\t\t\t} );\n\t\t\t\t\t\t}\n\n\t\t\t\t\t}, this ),\n\t\t\t\t\terror: _.bind( function () {\n\t\t\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t\t\t\tTVE_Dash.err( ThriveAB.t.variation_status_not_changed );\n\t\t\t\t\t}, this )\n\t\t\t\t} );\n\t\t\t}, this ),\n\t\t\ttitle: '',\n\t\t\tdescription: TVE_Dash.sprintf( ThriveAB.t.about_to_stop_variation, this.model.get( 'title' ) ),\n\t\t\tbtn_yes_txt: ThriveAB.t.stop,\n\t\t\tbtn_no_txt: ThriveAB.t.keep_it_running,\n\t\t\t'max-width': '20%',\n\t\t\twidth: '20%'\n\t\t} );\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/test/item.js");
						},
						"table.js": function (exports, module, require) {
							eval("var base = require( '../base' ),\n\ttest_item = require( './item' ),\n\tchange_automatic_winner_settings = require( '../../modals/automatic-winner-settings' ),\n\ttest_items_collection = require( '../../collections/test-items' ),\n\ttest_model = require( '../../models/test' ),\n\tgoal = require( './goal' ),\n\tmodal_goal = require( '../../modals/goal' );\n\nmodule.exports = base.extend( {\n\n\ttemplate: TVE_Dash.tpl( 'test/table' ),\n\n\tinitialize: function ( attr ) {\n\n\t\tthis.template = TVE_Dash.tpl( 'test/' + this.model.get( 'type' ) + '-table' );\n\n\t\tif ( attr.item_template_name ) {\n\t\t\tthis.item_template_name = attr.item_template_name;\n\t\t}\n\n\t\tvar raw_test = ThriveAB.current_test || ThriveAB.running_test;\n\n\t\tthis.active_items = new test_items_collection( _.filter( raw_test.items, {active: '1'} ) );\n\t\tthis.stopped_items = new test_items_collection( _.filter( raw_test.items, {active: '0'} ) );\n\n\t\tthis.listenTo( this.stopped_items, 'add', function ( model ) {\n\t\t\tthis.$stopped_item_list.append( this.render_item( model ).$el );\n\t\t} );\n\n\t\tthis.listenTo( this.active_items, 'remove', function ( model ) {\n\t\t\tthis.render_active_items();\n\t\t} );\n\n\t\tthis.listenTo( this.model, 'change:auto_win_enabled', this.toggle_auto_win_text );\n\n\t\tbase.prototype.initialize.apply( this, arguments );\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\t\tthis.toggle_auto_win_text( this.model );\n\n\t\tif ( this.model.get( 'status' ) === 'completed' ) {\n\t\t\tthis.$( '.thrive-ab-test-footer' ).hide();\n\t\t}\n\n\t\tthis.$item_list = this.$( '.thrive-ab-test-items' );\n\t\tthis.$stopped_item_list = this.$( '.thrive-ab-test-stopped-items' );\n\t\tthis.collection = this.model.get( 'items' );\n\n\t\tthis.render_variations();\n\t\tthis.render_goal_type();\n\n\t\treturn this;\n\t},\n\ttoggle_auto_win_text: function ( model ) {\n\n\t\tvar text = model.get( 'auto_win_enabled' ) != 0 ? ThriveAB.t.auto_win_enabled : ThriveAB.t.auto_win_disabled;\n\n\t\tthis.$( '#thrive-ab-auto-win-text' ).text( text );\n\t},\n\trender_variations: function () {\n\t\tthis.render_active_items();\n\t\tthis.render_stopped_items();\n\n\t},\n\n\trender_active_items: function () {\n\t\tthis.$item_list.empty();\n\n\t\tthis.active_items.each( function ( item ) {\n\t\t\tthis.$item_list.append( this.render_item( item ).$el );\n\t\t}, this );\n\n\t\treturn this;\n\t},\n\n\trender_stopped_items: function () {\n\n\t\tthis.$stopped_item_list.empty();\n\n\t\tthis.stopped_items.each( function ( item ) {\n\t\t\tthis.$stopped_item_list.append( this.render_item( item ).$el );\n\t\t}, this );\n\n\t\treturn this;\n\t},\n\n\trender_item: function ( item ) {\n\n\t\tvar item_view = new test_item( {\n\t\t\tmodel: item,\n\t\t\ttable_model: this.model,\n\t\t\tactive_items: this.active_items,\n\t\t\tstopped_items: this.stopped_items\n\t\t} );\n\n\t\tif ( this.item_template_name ) {\n\t\t\titem_view.template = TVE_Dash.tpl( this.item_template_name );\n\t\t} else if ( item.get( 'is_control' ) ) {\n\t\t\titem_view.template = TVE_Dash.tpl( 'test/item/control-view-' + this.model.get( 'type' ) );\n\t\t\titem_view.className = 'tab-control-row';\n\t\t} else if ( parseInt( item.get( 'active' ) ) === 0 ) {\n\t\t\titem_view.template = TVE_Dash.tpl( 'test/item/view-stopped-' + this.model.get( 'type' ) );\n\t\t} else {\n\t\t\titem_view.template = TVE_Dash.tpl( 'test/item/view-' + this.model.get( 'type' ) );\n\t\t}\n\n\t\treturn item_view.render();\n\t},\n\n\trender_goal_type: function () {\n\n\t\tnew goal( {\n\t\t\tel: this.$( '#thrive-ab-conversion-goals' ),\n\t\t\tmodel: this.model\n\t\t} ).render();\n\t},\n\n\t/**\n\t * Change Automatic Winner Settings\n\t */\n\tchange_automatic_winner_settings: function () {\n\n\t\tTVE_Dash.modal( change_automatic_winner_settings, {\n\t\t\tmodel: this.model,\n\t\t\ttitle: ThriveAB.t.automatic_winner_settings\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\tview_conversion_goal_details: function () {\n\n\t\tTVE_Dash.modal( modal_goal, {\n\t\t\tcollection: new Backbone.Collection( Object.values( this.model.get( 'goal_pages' ) ) ),\n\t\t\tmodel: this.model,\n\t\t\ttitle: ''\n\t\t} );\n\n\t\treturn false;\n\t}\n} );\n//# sourceURL=ab-page-testing/assets/js/views/test/table.js");
						}
					},
					"variation.js": function (exports, module, require) {
						eval("var base = require( './base' ),\n\tbase_model = require( './../models/base' ),\n\trange = require( '../controls/range' ),\n\tdelete_modal = require( '../modals/archive' ),\n\ttitle_editor = require( './../controls/edit_title' );\n\nmodule.exports = base.extend( {\n\n\tclassName: 'tvd-col tvd-l3 tvd-m6',\n\n\ttemplate: TVE_Dash.tpl( 'html-variation-card' ),\n\tinitialize: function ( args ) {\n\t\tbase.prototype.initialize.apply( this, args );\n\n\t\tthis.archived_variations = args.archived_variations;\n\t\tthis.published_variations = args.published_variations;\n\t},\n\tarchive: function () {\n\n\t\tTVE_Dash.modal( delete_modal, {\n\t\t\tsubmit: _.bind( function () {\n\t\t\t\tthis.remove();\n\t\t\t\tthis.model.set( 'action', 'archive' );\n\t\t\t\tthis.model.save();\n\n\t\t\t\tthis.published_variations.distribute_traffic( this.model.set( 'traffic', 0 ) );\n\t\t\t\tthis.published_variations.save_distributed_traffic();\n\t\t\t\tthis.archived_variations.add( this.model );\n\t\t\t\tthis.published_variations.remove( this.model );\n\t\t\t}, this ),\n\t\t\tmodel: this.model,\n\t\t\tbtn_yes_txt: ThriveAB.t.archive_title,\n\t\t\tbtn_no_txt: ThriveAB.t.cancel,\n\t\t\ttitle: ThriveAB.t.archive_variation,\n\t\t\tdescription: TVE_Dash.sprintf( ThriveAB.t.about_to_archive, this.model.get( 'post_title' ) )\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\tdelete: function () {\n\n\t\tTVE_Dash.modal( delete_modal, {\n\t\t\tsubmit: _.bind( function () {\n\t\t\t\tthis.remove();\n\t\t\t\tthis.model.destroy();\n\n\t\t\t\tthis.published_variations.equalize_traffic();\n\t\t\t\tthis.published_variations.save_distributed_traffic();\n\n\t\t\t}, this ),\n\t\t\tmodel: this.model,\n\t\t\tbtn_yes_txt: ThriveAB.t.delete_title,\n\t\t\tbtn_no_txt: ThriveAB.t.cancel,\n\t\t\ttitle: ThriveAB.t.delete_variation,\n\t\t\tdescription: TVE_Dash.sprintf( ThriveAB.t.about_to_delete, this.model.get( 'post_title' ) )\n\t\t} );\n\n\t\treturn false;\n\t},\n\n\tduplicate: function () {\n\t\tvar clone = this.model.clone(),\n\t\t\t_new_traffic = parseInt( 100 / ( this.published_variations.length + 1 ) );\n\n\t\tclone.set( {\n\t\t\tID: '',\n\t\t\tpost_title: 'Copy of ' + this.model.get( 'post_title' ),\n\t\t\tsource_id: this.model.get( 'ID' ),\n\t\t\ttraffic: _new_traffic,\n\t\t\tis_control: false,\n\t\t\tpost_parent: ThriveAB.page.ID\n\t\t} );\n\t\tTVE_Dash.showLoader();\n\t\tclone.save( null, {\n\t\t\tsuccess: _.bind( function ( model ) {\n\t\t\t\tthis.published_variations.add( model );\n\t\t\t\tthis.published_variations.equalize_traffic();\n\t\t\t\tthis.published_variations.save_distributed_traffic();\n\t\t\t\tTVE_Dash.success( ThriveAB.t.variation_added, 1000 );\n\t\t\t}, this ),\n\t\t\terror: function () {\n\t\t\t\tTVE_Dash.err( ThriveAB.t.add_variation_error );\n\t\t\t},\n\t\t\tcomplete: function () {\n\t\t\t\tTVE_Dash.hideLoader();\n\t\t\t}\n\t\t} );\n\t},\n\n\tedit_title: function ( e ) {\n\t\tvar self = this,\n\t\t\t$original_title = this.$el.find( '.thrive-ab-title-content' ),\n\t\t\teditModel = new base_model( {post_title: this.model.get( 'post_title' )} );\n\n\t\teditModel.on( 'thrive-ab-title-no-change', function () {\n\t\t\tself.$( '.thrive-ab-title-editor' ).html( '' );\n\t\t\t$original_title.show();\n\t\t} );\n\n\t\teditModel.on( 'change:post_title', function () {\n\t\t\tself.model.save( {post_title: editModel.get( 'post_title' )}, {patch: true} );\n\t\t\tself.$( '.thrive-ab-title-editor' ).html( '' );\n\t\t\t$original_title.find( '.thrive-ab-card-title' ).html( editModel.get( 'post_title' ) );\n\t\t\t$original_title.show();\n\t\t} );\n\n\t\tvar titleEditor = new title_editor( {\n\t\t\tel: this.$( '.thrive-ab-title-editor' ),\n\t\t\tmodel: editModel\n\t\t} );\n\t\t$original_title.hide().after( titleEditor.render().$el );\n\t\ttitleEditor.focus();\n\n\t\treturn false;\n\t},\n\n\trender: function () {\n\n\t\tthis.$el.html( this.template( {item: this.model} ) );\n\n\t\tnew range( {\n\t\t\tel: this.$( '.thrive-ab-card-footer' ),\n\t\t\tmodel: this.model\n\t\t} );\n\t}\n\n} );\n//# sourceURL=ab-page-testing/assets/js/views/variation.js");
					}
				}
			}
		}
	}
})("ab-page-testing/assets/js/main");
